%% Generate input
uimp = [0.1*ones(50, 1); 1; 1; 0.1*ones(50, 1)];
u = [zeros(10, 1); uimp; uimp; uimp];

%% Get Data
[speed, alpha, t] = run(u, "/dev/ttyACM0");
plot(t, speed);

%% Model ID
T = 0.04;
K = 300/0.1;
H = tf(K, [T 1]);

%% Validation
tsim = 0:10e-3:(length(speed)-1)*10e-3;
yest = lsim(H, u, tsim);
plot(t, speed, tsim, yest);